/*
SPDX-FileCopyrightText: 2007-2010 Johan Dahlin
SPDX-FileCopyrightText: 2008-2010 Colin Walters <walters@verbum.org>
SPDX-FileCopyrightText: 2008-2009, 2011-2012 Dan Winship
SPDX-FileCopyrightText: 2008 Jürg Billeter
SPDX-FileCopyrightText: 2008 Lucas Rocha
SPDX-FileCopyrightText: 2008 Marc-Andre Lureau
SPDX-FileCopyrightText: 2008 Philip Van Hoof
SPDX-FileCopyrightText: 2008 Tommi Komulainen
SPDX-FileCopyrightText: 2009 Andreas Rottmann <a.rottmann@gmx.at>
SPDX-FileCopyrightText: 2009 Robert Carr
SPDX-FileCopyrightText: 2010 Collabora, Ltd.
SPDX-FileCopyrightText: 2010 litl, LLC
SPDX-FileCopyrightText: 2010 Sugar Labs
SPDX-FileCopyrightText: 2011 Red Hat, Inc.
SPDX-FileCopyrightText: 2011 Torsten Schönfeld
SPDX-FileCopyrightText: 2018 Philip Chimento <philip.chimento@gmail.com>
SPDX-FileCopyrightText: 2018 Tomasz Miąsko
SPDX-FileCopyrightText: 2024 Simon McVittie
*/

#pragma once

#include <stdarg.h>
#include <sys/types.h> /* off_t, time_t */

#include <gio/gio.h> /* GAsyncReadyCallback */
#include <glib-object.h>
#include <glib.h>

#include "gitestmacros.h"
#include "utility.h"

#define REGRESS_FOO_SUCCESS_INT 0x1138

#define REGRESS_FOO_DEFINE_SHOULD_BE_EXPOSED "should be exposed"

#define REGRESS_FOO_PIE_IS_TASTY 3.14159

#define REGRESS_FOO_TYPE_INTERFACE (regress_foo_interface_get_type ())
#define REGRESS_FOO_INTERFACE(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), REGRESS_FOO_TYPE_INTERFACE, RegressFooInterface))
#define REGRESS_FOO_IS_INTERFACE(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), REGRESS_FOO_TYPE_INTERFACE))
#define REGRESS_FOO_INTERFACE_GET_INTERFACE(inst) (G_TYPE_INSTANCE_GET_INTERFACE ((inst), REGRESS_FOO_TYPE_INTERFACE, RegressFooInterfaceIface))

#define REGRESS_FOO_TYPE_SUBINTERFACE (regress_foo_sub_interface_get_type ())
#define REGRESS_FOO_SUBINTERFACE(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), REGRESS_FOO_TYPE_SUBINTERFACE, RegressFooSubInterface))
#define REGRESS_FOO_IS_SUBINTERFACE(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), REGRESS_FOO_TYPE_SUBINTERFACE))
#define REGRESS_FOO_SUBINTERFACE_GET_INTERFACE(inst) (G_TYPE_INSTANCE_GET_INTERFACE ((inst), REGRESS_FOO_TYPE_SUBINTERFACE, RegressFooSubInterfaceIface))

#define REGRESS_FOO_TYPE_OBJECT (regress_foo_object_get_type ())
#define REGRESS_FOO_OBJECT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), REGRESS_FOO_TYPE_OBJECT, RegressFooObject))
#define REGRESS_FOO_IS_OBJECT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), REGRESS_FOO_TYPE_OBJECT))

#define REGRESS_FOO_TYPE_SUBOBJECT (regress_foo_subobject_get_type ())
#define REGRESS_FOO_SUBOBJECT(subobject) (G_TYPE_CHECK_INSTANCE_CAST ((subobject), REGRESS_FOO_TYPE_SUBOBJECT, RegressFooSubobject))
#define REGRESS_FOO_IS_SUBOBJECT(subobject) (G_TYPE_CHECK_INSTANCE_TYPE ((subobject), REGRESS_FOO_TYPE_SUBOBJECT))

#define REGRESS_FOO_TYPE_BUFFER (regress_foo_buffer_get_type ())
#define REGRESS_FOO_BUFFER(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), REGRESS_FOO_TYPE_BUFFER, RegressFooBuffer))
#define REGRESS_FOO_IS_BUFFER(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), REGRESS_FOO_TYPE_BUFFER))

#define REGRESS_FOO_TYPE_OTHER_OBJECT (regress_foo_other_object_get_type ())
#define REGRESS_FOO_OTHER_OBJECT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), REGRESS_FOO_TYPE_OTHER_OBJECT, RegressFooOtherObject))
#define REGRESS_FOO_IS_OTHER_OBJECT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), REGRESS_FOO_TYPE_OTHER_OBJECT))

typedef struct _RegressFooInterface RegressFooInterface;
typedef struct _RegressFooInterfaceIface RegressFooInterfaceIface;
typedef struct _RegressFooSubInterface RegressFooSubInterface;
typedef struct _RegressFooSubInterfaceIface RegressFooSubInterfaceIface;
typedef struct _RegressFooObject RegressFooObject;
typedef struct _RegressFooObjectClass RegressFooObjectClass;
typedef struct _RegressFooSubobject RegressFooSubobject;
typedef struct _RegressFooSubobjectClass RegressFooSubobjectClass;
typedef struct _RegressFooBuffer RegressFooBuffer;
typedef struct _RegressFooBufferClass RegressFooBufferClass;
typedef struct _RegressFooOtherObject RegressFooOtherObject;
typedef struct _RegressFooOtherObjectClass RegressFooOtherObjectClass;

struct _RegressFooInterfaceIface
{
  GTypeInterface parent_iface;

  void (*do_regress_foo) (RegressFooInterface *self, int x);
};

GI_TEST_EXTERN
GType regress_foo_interface_get_type (void) G_GNUC_CONST;

GI_TEST_EXTERN
void regress_foo_interface_do_regress_foo (RegressFooInterface *iface, int x);

GI_TEST_EXTERN
void regress_foo_interface_static_method (int x);

struct _RegressFooSubInterfaceIface
{
  GTypeInterface parent_iface;

  /* signals */

  void (*destroy_event) (RegressFooSubInterface *self);

  /* virtual table */

  void (*do_bar) (RegressFooSubInterface *self);

  void (*do_baz) (RegressFooSubInterface *self, GCallback callback, gpointer user_data);
};

GI_TEST_EXTERN
GType regress_foo_sub_interface_get_type (void) G_GNUC_CONST;

GI_TEST_EXTERN
void regress_foo_sub_interface_do_bar (RegressFooSubInterface *self);

GI_TEST_EXTERN
void regress_foo_sub_interface_do_baz (RegressFooSubInterface *self,
                                       GCallback callback,
                                       gpointer user_data);

struct _RegressFooObject
{
  GObject parent_instance;

  int some_int;
};

struct _RegressFooObjectClass
{
  GObjectClass parent_class;

  gboolean (*virtual_method) (RegressFooObject *object, int first_param);

  /* Intended to match GFile */
  void (*read_fn) (RegressFooObject *object, int offset, int length);

  /* Test reserved stuff */
  GCallback _reserved[4];
};

GI_TEST_EXTERN
gint regress_foo_init (void);

GI_TEST_EXTERN
GT